close all
clear all
% DEFINITION OF THE GEOMETRY
gd=[2;4;0;1;1;0;0;0;1;1]; %canal
% MESH GENERATION
dl=decsg(gd);

    
[vertices,boundaries,elements]=initmesh(dl,'hmax',.3,'hgrad',1.7);
%mesh plot
pdemesh(vertices,boundaries,elements);
axis equal
verP1=vertices;
% P2 MESH
row4 = elements(4,:);
[elements,vertices,boundaries]=P1toP2mesh2D(elements,vertices,boundaries);
elements = [elements; row4];

%IDENTIFICATION OF the BOUNDARIES
boundaries(5,:)=2;
ind_left=find( vertices(1,boundaries(2,:))==0 & vertices(1,boundaries(1,:))==0);
ind_right=find( vertices(1,boundaries(2,:))==1 & vertices(1,boundaries(1,:))==1);
boundaries(5,ind_left)=1;
boundaries(5,ind_right)=1;

%NUMBERING
noe    = size(elements,2);          %number of elements
nov    = size(vertices,2);          %number of nodes
nov_v  = 2*nov;                     %number of dof for velocity
nov_p  = max(max(elements(1:3,:))); %number of dof for pressure

[detjac,dcdx,dcdy,dedx,dedy]=mygeotrasf2D(nov,vertices,noe,elements);
[MASSA,DERXX,DERYY,DERXY,DERX,DERY]=matricesP22D;
DERYX = DERXY';
[DIVX,DIVY]=matricesdivP2P12D;
nln_p =3;
nln_u =6;
l1 = [1:nln_u:(nln_u-1)*nln_u+1];
l2 = [nln_u:nln_u:nln_u*nln_u];
k = 1;
for i = 1:nln_u
    for j = 1:nln_p
        pl(i,j) = k;
        k = k + 1;
    end
end
gradgrad = [DERXX(:)'; DERYY(:)'; DERYX(:)'; DERXY(:)'];
clear DERXX DERYY DERXY DERX DERY
[u,diffusion,rho,p]=asseg_prop(vertices(1,:),vertices(2,:),noe,elements);

[matrix,M]=assemStokes(dcdx,dedx,dcdy,dedy,detjac,gradgrad,...
    vertices,elements,nln_u,nln_p,pl,nov,nov_v,nov_p,noe,DIVX,DIVY,...
    diffusion,rho,l1,l2,MASSA);

rhs = zeros(nov_v+nov_p,1);

%%%%%%%%%%%IMPOSING B.C.
DiriSideu2 = unique(find(boundaries(5,:)==2));
DiriSidev2 = unique(find(boundaries(5,:)==2));
DiriSideu1 = unique(find(boundaries(5,:)==1));
DiriSidev1 = unique(find(boundaries(5,:)==1));
DiriSideT  = unique(find(boundaries(5,:)==11));
Dirichletu1= unique([boundaries(1,DiriSideu1),boundaries(2,DiriSideu1),boundaries(3,DiriSideu1)]);
Dirichletv1= unique([boundaries(1,DiriSidev1),boundaries(2,DiriSidev1),boundaries(3,DiriSidev1)]);
Dirichletu2= unique([boundaries(1,DiriSideu2),boundaries(2,DiriSideu2),boundaries(3,DiriSideu2)]);
Dirichletv2= unique([boundaries(1,DiriSidev2),boundaries(2,DiriSidev2),boundaries(3,DiriSidev2)]);
DirichletT = unique([boundaries(1,DiriSideT),boundaries(2,DiriSideT),boundaries(3,DiriSideT)]);



%%%%%%%% GET DIRICHLET BC VALUES %%%%%%%%%%%%%%%%%%%%%%%%%%
uDir1=0.0+0*vertices(1,Dirichletu1);
vDir1=0+0*vertices(1,Dirichletv1);
uDir2=0+0*vertices(1,Dirichletu2);
vDir2=0+0*vertices(1,Dirichletv2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
p0=0;
%%%%%%%% IMPOSE BOUNDARY CONDITIONS %%%%%%%%%%%%%%%%%%%%%
fprintf('Imposing Dirichlet BC''s...');                 %
allDir=unique([Dirichletu1    , Dirichletu2,...       %
    Dirichletv1+nov, Dirichletv2+nov,nov_v+1]);

tic
Isp=speye(size(matrix));                                %
matrix(allDir,:)=Isp(allDir,:);                     %
toc


x=vertices(1,:);
y=vertices(2,:);


f=@(x,y) -12*(x-1).^2.*(2*y-1).*x.^2-4*(6*x.^2-6*x+1).*y.*(2*y.^2-3*y+1)-10;
f2=@(x,y) 12*(2*x-1).*(y-1).^2.*y.^2+4*(6*y.^2-6*y+1).*x.*(2*x.^2-3*x+1)+5*y;
fx =feval(f,x,y);
fy =feval(f2,x,y);

%%%
% YOU HAVE TO IMPLEMENT HERE THE EXACT RHS interpolating
%the exact rhs on the P2 field.
%%%



%%% IMPOSE DIRICHLET BCs ON rhs %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rhs([Dirichletu1,Dirichletu2,Dirichletv1+nov,Dirichletv2+nov,nov_v+1]) = ... %
    [uDir1(:);uDir2(:);vDir1(:);vDir2(:);p0];                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fprintf('\nSolving the linear system... ');         %
u = matrix\rhs;                                     %
fprintf('done!\n');                                 %
%clear matrix rhs %free some memory                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


u_ex=@(x,y) 20*(x-1).^2.*x.^2.*y.*(2*y.^2-3*y+1);
v_ex=@(x,y) -20*x.*(2*x.^2-3*x+1).*(y-1).^2.*y.^2;

u_exa =feval(u_ex,x,y);
v_exa =feval(v_ex,x,y);

xp1=verP1(1,:);
yp1=verP1(2,:);

p_ex=@(xp1,yp1) 2.5.*yp1.^2-10.*xp1;
p_exa=feval(p_ex,xp1,yp1);

[errorL2]=L2error(vertices,noe,elements,detjac,u(1:nov_v));
realerror(ft)=sqrt(errorL2(1)+errorL2(2))

[errorL2pres]=L2error_pres(vertices,noe,elements,detjac,u(nov_v+1:end));
realpreserror(ft)=sqrt(errorL2pres)


% nodv  = max(max(elements(1:3,:)));
% figure(333)
% acca=quiver(vertices(1,1:nodv),vertices(2,1:nodv),u(1:nodv)',u(1+nov:nodv+nov)'); set(acca,'Color','k');
% hold on
% pdemesh(vertices,boundaries,elements)
% 
% figure(666)
% h2=disegnaisoline(vertices(:,1:nov_p),elements,u(nov_v+1:end),100,100,200);
% axis off
% axis image
% colormap('jet'); view(2)
% 
% velP2=sqrt(u(1:nov).^2+u(nov+1:2*nov).^2);
% figure(100)
% h=pdesurfP2(vertices,elements,velP2');
% axis off
% axis image
% set(h,'edgecolor','none')
% set(h,'facelighting','phong')
% 
% pressione=u(nov_v+1:end);
% modulo_vel=sqrt(u(1:nov_p).^2+u(nov+1:nov+nov_p).^2);
% 
% mod_velex=sqrt(u_exa'.^2+v_exa'.^2);
% figure(155)
% h=pdesurfP2(vertices,elements,mod_velex');
% axis off
% axis image
% set(h,'edgecolor','none')
% set(h,'facelighting','phong')
% 
% 
% figure(444)
% Vx=u(1:nov);
% Vy=u(nov+1:nov_v);
% h1=disegnastreamline(vertices,elements,Vx,Vy,200,20,5,10);
% axis off
% axis image
% set(h1,'Erasemode','none')
% set(h1,'color','k')
% hold on
% pdemesh(vertices,boundaries,[])
